#ifndef _qsoft_ch
#define _qsoft_ch

#DEFINE KEY_LUPA  "k"

#DEFINE PSW_NEGADO      0
#DEFINE PSW_LECTURA     1
#DEFINE PSW_ESCRITURA   2
#DEFINE PSW_BORRADO     3

#ifdef __XHARBOUR1__
#XCOMMAND data <var> [ init <val> ] as block => data <var> [ init <val> ] as codeblock
#endif

#ifndef _FIVEWIN_CH
   #define CRLF   chr( 13 ) + chr( 10 )
#else
   #command ?? [ <list,...> ] => monitoreo( <list> )
#endif

#xcommand DEFAULT <xVar1> := <xVal1> ;
            [, <xVarN> := <xValN> ] => ;
               <xVar1> := If( <xVar1> == nil, <xVal1>, <xVar1> ) ;;
            [ <xVarN> := If( <xVarN> == nil, <xValN>, <xVarN> ); ]

#xtranslate BYNAME <var> [, <varN> ]   => ::<var> := <var> [; ::<varN> := <varN> ]
#xtranslate BYNAME <var> DEFAULT <val> => ::<var> := BYDEFAULT <var>, <val>
#xtranslate BYNAME <var> IFNONIL       => ;
                            if <var> != NIL ;;
                                ::<var> := <var> ;;
                            end
#xtranslate BYDEFAULT <var>, <val>     => if( <var> == NIL, <val>, <var> )

#TRANSLATE entre( <x>, <y>, <z> ) => ( <x> >= <y> .AND. <x> <= <z> )

#XTRANSLATE tGet() => tGetFer()

//----------------------------------------------------------------------------------------------------------------------
// CLASE TMABREBROW

#xcommand DEFINE WINDOW BROWSE <oDlg> [MDICHILD] [ FIELDS <Flds,...>] [ARRAY <array>] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ MENUINFO <nMenuInfo> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [ WITH <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [ TO <aIndexNum,...> ] [ MESSAGE <aIndexMsg,...> ] [ SET <nIndice> ] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [ <eof: EOF> ] ;
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
      => ;
         <oDlg> = qMTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, ;
            [ \{ || \{ <Flds> \} \} ] [ <array> ], [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{<aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <nMenuInfo> ) ;;
         <oDlg>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE WINDOW BROWSE <oDlg> FIELDS ;
            [MDICHILD] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ MENUINFO <nMenuInfo> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [ WITH <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [ TO <aIndexNum,...> ] [ MESSAGE <aIndexMsg,...> ] [ SET <nIndice> ] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [ <eof: EOF> ] ;
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
      => ;
         <oDlg> = qMTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>,, [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{<aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <nMenuInfo> ) ;;
         <oDlg>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE WINDOW BROWSE <oDlg> [MDICHILD] [ FIELDS <Flds,...>] [ARRAY <array>] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ MENUINFO <nMenuInfo> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [ WITH <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [ TO <aIndexNum,...> ] [ MESSAGE <aIndexMsg,...> ] [ SET <nIndice> ] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [ <eof: EOF> ] ;
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
      => ;
         <oDlg> = qMTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, ;
            [ \{ || \{ <Flds> \} \} ] [ <array> ], [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            [ \{ | self | <uBtn> \} ],<oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{<aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <nMenuInfo> )

#xcommand DEFINE WINDOW BROWSE <oDlg> FIELDS ;
            [MDICHILD] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ MENUINFO <nMenuInfo> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [ WITH <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [ TO <aIndexNum,...> ] [ MESSAGE <aIndexMsg,...> ] [ SET <nIndice> ] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [ <eof: EOF> ] ;
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
      => ;
         <oDlg> = qMTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>,, [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            [ \{ | self | <uBtn> \} ],<oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{<aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <nMenuInfo> )

//----------------------------------------------------------------------------------------------------------------------
// CLASE TWABREBROW

#xcommand DEFINE WINDOW BROWSE <oDlg> [ FIELDS <Flds,...>] [ARRAY <array> ];
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>] ];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>] ];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> := qWTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, [ \{ || \{<Flds> \} \} ][ <array> ], ;
            [ \{ <aHeaders> \} ], <oWnd>, [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, [ \{ <aIndexMsg> \} ], [ \{<aIndexNum> \} ], ;
            [ \{ <aIndexTxt> \} ], <nIndice>, [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, [ \{ <aColSizes> \} ], ;
            <cAlias>, [ \{ || <uChange> \} ], [ \{ | nRow, nCol, nFlags | <uRClick> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> ) ;;
         <oDlg>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE WINDOW BROWSE <oDlg> FIELDS ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>] ];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>] ];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> := qWTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>,, ;
            [ \{ <aHeaders> \} ], <oWnd>, [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, [ \{ <aIndexMsg> \} ], [ \{<aIndexNum> \} ], ;
            [ \{ <aIndexTxt> \} ], <nIndice>, [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, [ \{ <aColSizes> \} ], ;
            <cAlias>, [ \{ || <uChange> \} ], [ \{ | nRow, nCol, nFlags | <uRClick> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> ) ;;
         <oDlg>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE WINDOW BROWSE <oDlg> [ FIELDS <Flds,...>] [ARRAY <array> ];
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>] ];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>] ];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> = qWTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, [ \{ || \{<Flds> \} \} ][ <array> ], ;
            [ \{ <aHeaders> \} ], <oWnd>, [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            [ \{ | self | <uBtn> \} ], <oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, [ \{ <aIndexMsg> \} ], ;
            [ \{<aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ], ;
            [ \{ <aPrintTxt> \} ], [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], [ \{ | nRow, nCol, nFlags | <uRClick> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> )

#xcommand DEFINE WINDOW BROWSE <oDlg> FIELDS ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>] ];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>] ];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> = qWTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>,, ;
            [ \{ <aHeaders> \} ], <oWnd>, [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            [ \{ | self | <uBtn> \} ], <oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, [ \{ <aIndexMsg> \} ], ;
            [ \{<aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ], ;
            [ \{ <aPrintTxt> \} ], [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], [ \{ | nRow, nCol, nFlags | <uRClick> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> )

//----------------------------------------------------------------------------------------------------------------------

// Dialogo con el browse en pantalla completa (como las ventanas)
#xcommand DEFINE DIALOG BROWSE <oDlg> [ FIELDS <Flds,...>] [ARRAY <array>];
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>]];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>]];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> = qDTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, ;
            [ \{ || \{ <Flds> \} \} ][ <array> ], [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ] ,[ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> ) ;;
         <oDlg>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE DIALOG BROWSE <oDlg> FIELDS ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>]];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>]];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> = qDTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>,, [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ] ,[ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> ) ;;
         <oDlg>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE DIALOG BROWSE <oDlg> [ FIELDS <Flds,...>] [ARRAY <array>];
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>]];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>]];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> = qDTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, ;
            [ \{ || \{ <Flds> \} \} ][ <array> ], [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            [ \{ | self | <uBtn> \} ], <oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ] ,[ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> )

#xcommand DEFINE DIALOG BROWSE <oDlg> FIELDS ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>]];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>]];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
       => ;
         <oDlg> = qDTbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>,, [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            [ \{ | self | <uBtn> \} ], <oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ] ,[ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <cAlias>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush> )

//Dialogo con el browse en un recurso
#xcommand DEFINE DIALOG BROWSE <oDlg> [ FIELDS <Flds,...>] [ARRAY <array>];
            [ <resource: NAME, RESNAME, RESOURCE> <cResName> ] ;
            [ <lib: LIBRARY, DLL> <hResources> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ <update: UPDATE> ] ;
            [ WHEN <uWhen> ] ;
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ [ BROWSE ] ID <nId> ] ;
            [ TABS ID <nIdTabs> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>]];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>]];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
            [ <design: DESIGN> ] ;
            [ VALID <uValid> ] ;
       => ;
         <oDlg> := qDTbrowse():New( ,,,, [ \{|| \{<Flds> \} \} ] [ <array> ], [ \{<aHeaders>\}], ;
            <oWnd>, [\{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick>\} ], ;
            <cTitle>,, <oMenu>,,,,, [ \{<aIndexMsg>\} ], [ \{<aIndexNum>\} ], [ \{<aIndexTxt>\} ], ;
            <nIndice>, [ \{<aPrintBlk>\} ], [ \{<aPrintMsg>\} ], [ \{<aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>,, <oIco>, [ \{ <aColSizes> \} ], <cAlias>, ;
            [ \{ || <uChange> \} ], [ \{ | nRow, nCol, nFlags | <uRClick> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush>, <cResName>, <hResources>, <nId>, ;
            <.update.>, <{uWhen}>, <nIdTabs>, <.design.>, <{uValid}> )

#xcommand DEFINE DIALOG BROWSE <oDlg> FIELDS ;
            [ <resource: NAME, RESNAME, RESOURCE> <cResName> ] ;
            [ <lib: LIBRARY, DLL> <hResources> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ <update: UPDATE> ] ;
            [ WHEN <uWhen> ] ;
            [ TITLE <cTitle> ] ;
            [ ALIAS <cAlias> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ [ BROWSE ] ID <nId> ] ;
            [ TABS ID <nIdTabs> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>]];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>]];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
            [ <design: DESIGN> ] ;
            [ VALID <uValid> ] ;
       => ;
         <oDlg> := qDTbrowse():New( ,,,,, [ \{<aHeaders>\}], ;
            <oWnd>, [\{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick>\} ], ;
            <cTitle>,, <oMenu>,,,,, [ \{<aIndexMsg>\} ], [ \{<aIndexNum>\} ], [ \{<aIndexTxt>\} ], ;
            <nIndice>, [ \{<aPrintBlk>\} ], [ \{<aPrintMsg>\} ], [ \{<aPrintTxt> \} ], ;
            [ \{ | xSeek | <uSeek> \} ], <.eof.>,, <oIco>, [ \{ <aColSizes> \} ], <cAlias>, ;
            [ \{ || <uChange> \} ], [ \{ | nRow, nCol, nFlags | <uRClick> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush>, <cResName>, <hResources>, <nId>, ;
            <.update.>, <{uWhen}>, <nIdTabs>, <.design.>, <{uValid}> )

#xcommand ACTIVATE DIALOG <oDlg> [var <lResult>];
            [ <center: CENTER, CENTERED> [ <inwnd: IN PARENT> ] ] ;
            [ <NonModal: NOWAIT, NOMODAL> ] ;
            [ WHEN <uWhen> ] ;
            [ VALID <uValid> ] ;
            [ ON [ LEFT ] CLICK <uClick> ] ;
            [ ON INIT <uInit> ] ;
            [ ON MOVE <uMoved> ] ;
            [ ON PAINT <uPaint> ] ;
            [ ON RIGHT CLICK <uRClicked,...> ] ;
            [ <Resize16: RESIZE16> ] ;
        => ;
[ <lResult> := ] <oDlg>:Activate(<oDlg>:bLClicked [ := {|nRow,nCol,nFlags|<uClick>}], ;
                                <oDlg>:bMoved    [ := <{uMoved}> ], ;
                                <oDlg>:bPainted  [ := {|hDC,cPS|<uPaint>}],;
                                <.center.>, [{|Self|<uValid>}],;
                                [ ! <.NonModal.> ], [{|Self|<uInit>}],;
                                <oDlg>:bRClicked [ := {|nRow,nCol,nFlags|<uRClicked>}],;
                                [{|Self|<uWhen>}], [<.Resize16.>], [<.inwnd.>] )

//-------------------------------------------------------------------------------------------------------------------------
// CLASE CONTROL
// short: LISTBOX - BROWSE
// Warning: SELECT <cField>  ==> Must be the Field key of the current INDEX !!!

#xcommand REDEFINE CONTROL BROWSE <oLbx> [ FIELDS <Flds,...>] [ARRAY <array>] ;
            [ ALIAS <cAlias> ] ;
            [ ID <nId> ] ;
            [ <dlg:OF,DIALOG> <oDlg> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS,TITLE> <aHeaders,...> ] ;
            [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ ON [ LEFT ] DBLCLICK <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ FONT <oFont> ] ;
            [ CURSOR <oCursor> ] ;
            [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
            [ MESSAGE <cMsg> ] ;
            [ <update: UPDATE> ] ;
            [ WHEN <uWhen> ] ;
            [ VALID <uValid> ] ;
            [ ACTION <uAction,...> ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
       => ;
            <oLbx> := tCAbreBrow():ReDefine( <nId>, ;
            [\{|| \{ <Flds> \} \}][<array>], <oDlg>,;
            [ \{<aHeaders>\}], [\{<aColSizes>\}],;
            <(cField)>, <uValue1>, <uValue2>,;
            [\{||<uChange>\}],;
            [\{|nRow,nCol,nFlags,lModif,lNew,self|<uLDblClick>\}],;
            [\{|nRow,nCol,nFlags|<uRClick>\}],;
            <oFont>, <oCursor>, <nClrFore>, <nClrBack>, <cMsg>, <.update.>,;
            <cAlias>, <{uWhen}>, <{uValid}>,;
            [\{|nRow,nCol,nFlags|<uLClick>\}], [\{<{uAction}>\}],;
            [\{|xSeek,nIndex|<uSeek>\}],<.eof.> )

#xcommand REDEFINE CONTROL BROWSE <oLbx> FIELDS ;
            [ ALIAS <cAlias> ] ;
            [ ID <nId> ] ;
            [ <dlg:OF,DIALOG> <oDlg> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS,TITLE> <aHeaders,...> ] ;
            [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ ON [ LEFT ] DBLCLICK <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ FONT <oFont> ] ;
            [ CURSOR <oCursor> ] ;
            [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
            [ MESSAGE <cMsg> ] ;
            [ <update: UPDATE> ] ;
            [ WHEN <uWhen> ] ;
            [ VALID <uValid> ] ;
            [ ACTION <uAction,...> ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
       => ;
            <oLbx> := tCAbreBrow():ReDefine( <nId>,,;
            [ \{<aHeaders>\}], [\{<aColSizes>\}],;
            <(cField)>, <uValue1>, <uValue2>,;
            [\{||<uChange>\}],;
            [\{|nRow,nCol,nFlags,lModif,lNew,self|<uLDblClick>\}],;
            [\{|nRow,nCol,nFlags|<uRClick>\}],;
            <oFont>, <oCursor>, <nClrFore>, <nClrBack>, <cMsg>, <.update.>,;
            <cAlias>, <{uWhen}>, <{uValid}>,;
            [\{|nRow,nCol,nFlags|<uLClick>\}], [\{<{uAction}>\}],;
            [\{|xSeek,nIndex|<uSeek>\}],<.eof.> )

#xcommand @ <nRow>, <nCol> CONTROL BROWSE <oBrw> [ FIELDS <Flds,...> ] [ARRAY <array>] ;
            [ ALIAS <cAlias> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS,TITLE> <aHeaders,...> ] ;
            [ SIZE <nWidth>, <nHeigth> ] ;
            [ <dlg:OF,DIALOG> <oDlg> ] ;
            [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ ON [ LEFT ] DBLCLICK <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ FONT <oFont> ] ;
            [ CURSOR <oCursor> ] ;
            [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
            [ MESSAGE <cMsg> ] ;
            [ <update: UPDATE> ] ;
            [ <pixel: PIXEL> ] ;
            [ WHEN <uWhen> ] ;
            [ <design: DESIGN> ] ;
            [ ACTION <uAction,...> ] ;
            [ VALID <uValid> ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
      => ;
          <oBrw> := tCAbreBrow():New( <nRow>, <nCol>, <nWidth>, <nHeigth>,;
                           [\{|| \{<Flds> \} \}][<array>], ;
                           [\{<aHeaders>\}], [\{<aColSizes>\}], ;
                           <oDlg>, <(cField)>, <uValue1>, <uValue2>,;
                           [\{||<uChange>\}],;
                           [\{|nRow,nCol,nFlags,lModif,lNew,self|<uLDblClick>\}],;
                           [\{|nRow,nCol,nFlags|<uRClick>\}],;
                           <oFont>, <oCursor>, <nClrFore>, <nClrBack>, <cMsg>,;
                           <.update.>, <cAlias>, <.pixel.>, <{uWhen}>,;
                           <.design.>, <{uValid}>, <{uLClick}>,;
                           [\{<{uAction}>\}];
                           [\{|xSeek,nIndex|<uSeek>\}], <.eof.> )

#xcommand @ <nRow>, <nCol> CONTROL BROWSE <oBrw> FIELDS  ;
            [ ALIAS <cAlias> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS,TITLE> <aHeaders,...> ] ;
            [ SIZE <nWidth>, <nHeigth> ] ;
            [ <dlg:OF,DIALOG> <oDlg> ] ;
            [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ ON [ LEFT ] DBLCLICK <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ FONT <oFont> ] ;
            [ CURSOR <oCursor> ] ;
            [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
            [ MESSAGE <cMsg> ] ;
            [ <update: UPDATE> ] ;
            [ <pixel: PIXEL> ] ;
            [ WHEN <uWhen> ] ;
            [ <design: DESIGN> ] ;
            [ ACTION <uAction,...> ] ;
            [ VALID <uValid> ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
      => ;
          <oBrw> := tCAbreBrow():New( <nRow>, <nCol>, <nWidth>, <nHeigth>,, ;
                           [\{<aHeaders>\}], [\{<aColSizes>\}], ;
                           <oDlg>, <(cField)>, <uValue1>, <uValue2>,;
                           [\{||<uChange>\}],;
                           [\{|nRow,nCol,nFlags,lModif,lNew,self|<uLDblClick>\}],;
                           [\{|nRow,nCol,nFlags|<uRClick>\}],;
                           <oFont>, <oCursor>, <nClrFore>, <nClrBack>, <cMsg>,;
                           <.update.>, <cAlias>, <.pixel.>, <{uWhen}>,;
                           <.design.>, <{uValid}>, <{uLClick}>,;
                           [\{<{uAction}>\}];
                           [\{|xSeek,nIndex|<uSeek>\}], <.eof.> )

//-------------------------------------------------------------------------------------------------------------------------
// CLASE TXABREBROW
#xcommand DEFINE WINDOW XBROWSE <oDlg> [ MDICHILD ] [ [ FIELDS ] <Flds,...> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ <pic: PICS, PICTURE, PICTURES> <aPics,...>] ;
            [ <cols: COLS, COLUMNS> <aCols,...>] ;
            [ <idx: SORT, ORDERS> <aSort,...> ] ;
            [ JUSTIFY <aJust,...> ] ;
            [ <dsrc: ALIAS, ARRAY, RECSET, RECORDSET, OBJECT> <uDataSrc> ] ;
            [ TITLE <cTitle> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ MENUINFO <nMenuInfo> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [ WITH <uBtnDel,...> ] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...> ] [ MESSAGE <aIndexMsg,...>] [ SET <nIndice> ] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [ <eof: EOF> ] ;
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
            [ VALID <uValid> ] ;
            [ <autosort: AUTOSORT> ] ;
            [ <autocols: AUTOCOLS> ] ;
            [ <footers: FOOTERS> ] ;
            [ <fasted: FASTEDIT> ] ;
            [ <lcell: CELL> ] [ <llines: LINES> ] ;
      => ;
         <oDlg> = qMXbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, [ \{ <{Flds}> \} ], ;
            [ \{ <aHeaders> \} ], <oWnd>, [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], ;
            <cTitle>, .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{<aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek, nIndex | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <uDataSrc>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <nMenuInfo>, <{uValid}>, <.autosort.>, <.autocols.>, [ \{ <aPics> \} ], [ \{ <aCols> \} ], ;
            [ \{ <aJust> \} ], [ \{ <aSort> \} ], <.footers.>, <.fasted.>, <.lcell.>, <.llines.> ) ;;
         <oDlg>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE WINDOW XBROWSE <oDlg> [ MDICHILD ] [ [ FIELDS ] <Flds,...> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ <pic: PICS, PICTURE, PICTURES> <aPics,...>] ;
            [ <cols: COLS, COLUMNS> <aCols,...>] ;
            [ <idx: SORT, ORDERS> <aSort,...> ] ;
            [ JUSTIFY <aJust,...> ] ;
            [ <dsrc: ALIAS, ARRAY, RECSET, RECORDSET, OBJECT> <uDataSrc> ] ;
            [ TITLE <cTitle> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ MENUINFO <nMenuInfo> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [ WITH <uBtnDel,...> ] ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...> ] [ MESSAGE <aIndexMsg,...>] [ SET <nIndice> ] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [ <eof: EOF> ] ;
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
            [ VALID <uValid> ] ;
            [ <autosort: AUTOSORT> ] ;
            [ <autocols: AUTOCOLS> ] ;
            [ <footers: FOOTERS> ] ;
            [ <fasted: FASTEDIT> ] ;
            [ <lcell: CELL> ] [ <llines: LINES> ] ;
      => ;
         <oDlg> = qMXbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, [ \{ <{Flds}> \} ], ;
            [ \{ <aHeaders> \} ], <oWnd>, [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], ;
            <cTitle>, [ \{ | self | <uBtn> \} ], <oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{ <aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{<aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek, nIndex | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <uDataSrc>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <nMenuInfo>, <{uValid}>, <.autosort.>, <.autocols.>, [ \{ <aPics> \} ], [ \{ <aCols> \} ], ;
            [ \{ <aJust> \} ], [ \{ <aSort> \} ], <.footers.>, <.fasted.>, <.lcell.>, <.llines.> )

//-------------------------------------------------------------------------------------------------------------------------
// CLASE TXABREBROW
#xcommand DEFINE WINDOW XBROWSE <oBrw> [ [ FIELDS ] <Flds,...> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ <pic: PICS, PICTURE, PICTURES> <aPics,...> ] ;
            [ <cols: COLS, COLUMNS> <aCols,...>] ;
            [ <idx: SORT, ORDERS> <aSort,...> ] ;
            [ JUSTIFY <aJust,...> ] ;
            [ <dsrc: ALIAS, ARRAY, RECSET, RECORDSET, OBJECT> <uDataSrc> ] ;
            [ TITLE <cTitle> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [ TO <aIndexNum,...>] [ MESSAGE <aIndexMsg,...>] [ SET <nIndice>] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
            [ VALID <uValid> ] ;
            [ <autosort: AUTOSORT> ] ;
            [ <autocols: AUTOCOLS> ] ;
            [ <footers: FOOTERS> ] ;
            [ <fasted: FASTEDIT> ] ;
            [ <lcell: CELL> ] [ <llines: LINES> ] ;
      => ;
         <oBrw> := qWXbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, [ \{ <{Flds}> \} ], ;
            [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            .f., .f., <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{<aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek, nIndex | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <uDataSrc>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <{uValid}>, <.autosort.>, <.autocols.>, [ \{ <aPics> \} ], [ \{ <aCols> \} ], ;
            [ \{ <aJust> \} ], [ \{ <aSort> \} ], <.footers.>, <.fasted.>, <.lcell.>, <.llines.> ) ;;
         <oBrw>:setMenu( eval( <{bMenuBar}> ) )

#xcommand DEFINE WINDOW XBROWSE <oBrw> [ [ FIELDS ] <Flds,...> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ] ;
            [ <pic: PICS, PICTURE, PICTURES> <aPics,...> ] ;
            [ <cols: COLS, COLUMNS> <aCols,...>] ;
            [ <idx: SORT, ORDERS> <aSort,...> ] ;
            [ JUSTIFY <aJust,...> ] ;
            [ <dsrc: ALIAS, ARRAY, RECSET, RECORDSET, OBJECT> <uDataSrc> ] ;
            [ TITLE <cTitle> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ <edit: EDIT> ] ;
            [ <yesNo: YESNO> ] ;
            [ <del: DEL,DELETE> [WITH  <uBtnDel,...>] ] ;
            [ [ON] INDEX <aIndexTxt,...> [ TO <aIndexNum,...>] [ MESSAGE <aIndexMsg,...>] [ SET <nIndice>] ] ;
            [ PRINT <aPrintTxt,...> [ TO <aPrintBlk,...> ] [ MESSAGE <aPrintMsg,...> ] ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <pixel: PIXEL> ] ;
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
            [ VALID <uValid> ] ;
            [ <autosort: AUTOSORT> ] ;
            [ <autocols: AUTOCOLS> ] ;
            [ <footers: FOOTERS> ] ;
            [ <fasted: FASTEDIT> ] ;
            [ <lcell: CELL> ] [ <llines: LINES> ] ;
      => ;
         <oBrw> := qWXbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, [ \{ <{Flds}> \} ], ;
            [ \{ <aHeaders> \} ], <oWnd>, ;
            [ \{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], <cTitle>, ;
            [ \{ | self | <uBtn> \} ], <oMenu>, <.pixel.>, <.edit.>, <.yesNo.>, <.del.>, ;
            [ \{ <aIndexMsg> \} ], [ \{<aIndexNum> \} ], [ \{ <aIndexTxt> \} ], <nIndice>, ;
            [ \{ <aPrintBlk> \} ], [ \{ <aPrintMsg> \} ], [ \{ <aPrintTxt> \} ], ;
            [ \{ | xSeek, nIndex | <uSeek> \} ], <.eof.>, [ \{ || \{ <uBtnDel> \} \} ], <oIco>, ;
            [ \{ <aColSizes> \} ], <uDataSrc>, [ \{ || <uChange> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uRClick> \} ], [ \{ | nRow, nCol, nFlags | <uLClick> \} ], ;
            <oBrush>, <{uValid}>, <.autosort.>, <.autocols.>, [ \{ <aPics> \} ], [ \{ <aCols> \} ], ;
            [ \{ <aJust> \} ], [ \{ <aSort> \} ], <.footers.>, <.fasted.>, <.lcell.>, <.llines.> )

//-------------------------------------------------------------------------------------------------------------------------
//Dialogo con el browse en un recurso (XBROWSE)
#xcommand DEFINE DIALOG XBROWSE <oDlg> [ [ FIELDS ] <Flds,...>] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ];
            [ <head:HEAD,HEADER,HEADERS> <aHeaders,...> ];
            [ <pic: PICS, PICTURE, PICTURES> <aPics,...>] ;
            [ <cols: COLS, COLUMNS> <aCols,...>] ;
            [ <idx: SORT, ORDERS> <aSort,...> ] ;
            [ JUSTIFY <aJust,...> ] ;
            [ <update: UPDATE> ] ;
            [ WHEN <uWhen> ] ;
            [ <dsrc: ALIAS, ARRAY, RECSET, RECORDSET, OBJECT> <uDataSrc> ] ;
            [ TITLE <cTitle> ] ;
            [ <resource: NAME, RESNAME, RESOURCE> <cResName> ] ;
            [ <lib: LIBRARY, DLL> <hResources> ] ;
            [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ <action:ON DBLCLICK,ACTION> <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ <of: WINDOW, DIALOG, OF> <oWnd> ] ;
            [ [ BROWSE ] ID <nId> ] ;
            [ TABS ID <nIdTabs> ] ;
            [ <bar: BUTTONBAR, BTNBAR, BAR> <uBtn> ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ MENU <oMenu> ] ;
            [ MENUBAR <bMenuBar> ] ;
            [ [ON] INDEX <aIndexTxt,...> [TO <aIndexNum,...>] [MESSAGE <aIndexMsg,...>] [SET <nIndice>]];
            [ PRINT <aPrintTxt,...> [TO <aPrintBlk,...>] [MESSAGE <aPrintMsg,...>]];
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ ICON <oIco> ] ;
            [ BRUSH <oBrush> ] ;
            [ <design: DESIGN> ] ;
            [ VALID <uValid> ] ;
            [ <autosort: AUTOSORT> ] ;
            [ <autocols: AUTOCOLS> ] ;
            [ <footers: FOOTERS> ] ;
            [ <fasted: FASTEDIT> ] ;
            [ <lcell: CELL> ] [ <llines: LINES> ] ;
       => ;
         <oDlg> := qDXbrowse():new( <nTop>, <nLeft>, <nBottom>, <nRight>, [ \{ <{Flds}> \} ], ;
            [ \{ <aHeaders> \} ], <oWnd>, [\{ | nRow, nCol, nFlags, lModif, lNew, self | <uLDblClick> \} ], ;
            <cTitle>, if( <.bMenuBar.>, [ \{ | self | <bMenuBar> \} ], [ \{ | self | <uBtn> \} ] ), ;
            if( <.bMenuBar.>, .f., <oMenu> ),,,,, [ \{<aIndexMsg>\} ], [ \{<aIndexNum>\} ], ;
            [ \{<aIndexTxt>\} ], <nIndice>, [ \{<aPrintBlk>\} ], [ \{<aPrintMsg>\} ], [ \{<aPrintTxt>\} ], ;
            [ \{ | xSeek, nIndex | <uSeek> \} ], <.eof.>,, <oIco>, [ \{ <aColSizes> \} ], <uDataSrc>, ;
            [ \{ || <uChange> \} ], [ \{ | nRow, nCol, nFlags | <uRClick> \} ], ;
            [ \{ | nRow, nCol, nFlags | <uLClick> \} ], <oBrush>, <cResName>, <hResources>, <nId>, ;
            <.update.>, <{uWhen}>, <nIdTabs>, <.design.>, <{uValid}>, <.autosort.>, <.autocols.>, ;
            [ \{ <aPics> \} ], [ \{ <aCols> \} ], [ \{ <aJust> \} ], [ \{ <aSort> \} ], ;
            <.footers.>, <.fasted.>, <.lcell.>, <.llines.> )

//-------------------------------------------------------------------------------------------------------------------------
// CLASE CONTROL
// short: XBROWSE

#xcommand REDEFINE [ COLUMN ] QXBROWSE <oLbx> [ [ FIELDS ] <Flds,...>] ;
            [ <dsrc: ALIAS, ARRAY, RECSET, RECORDSET, OBJECT> <uDataSrc> ] ;
            [ ID <nId> ] ;
            [ <dlg:OF,DIALOG> <oDlg> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS,TITLE> <aHeaders,...> ] ;
            [ <pic: PICS, PICTURE, PICTURES> <aPics,...>] ;
            [ <cols: COLS, COLUMNS> <aCols,...>] ;
            [ <idx: SORT, ORDERS> <aSort,...> ] ;
            [ JUSTIFY <aJust,...> ] ;
            [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ ON [ LEFT ] DBLCLICK <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ FONT <oFont> ] ;
            [ CURSOR <oCursor> ] ;
            [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
            [ MESSAGE <cMsg> ] ;
            [ <update: UPDATE> ] ;
            [ WHEN <uWhen> ] ;
            [ <design: DESIGN> ] ;
            [ VALID <uValid> ] ;
            [ <autosort: AUTOSORT> ] ;
            [ <autocols: AUTOCOLS> ] ;
            [ ACTION <uAction,...> ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <footers: FOOTERS> ] ;
            [ <fasted: FASTEDIT> ] ;
            [ <lcell: CELL> ] [ <llines: LINES> ] ;
       => ;
            <oLbx> := qXbrowseNew( <oDlg>, nil, nil, nil, nil,;
                     [ \{ <{Flds}> \} ], ;
                     [\{<aHeaders>\}], [\{<aColSizes>\}], ;
                     [<{uChange}>],;
                     [\{|nRow,nCol,nFlags,lNew,self|<uLDblClick>\}],;
                     [\{|nRow,nCol,nFlags|<uRClick>\}],;
                     <oFont>, <oCursor>, <nClrFore>, <nClrBack>, <cMsg>,;
                     <.update.>, <uDataSrc>, <{uWhen}>,;
                     <.design.>, <{uValid}>, .t., <nId>, <.autosort.>, <.autocols.> , ;
                     [\{<aPics>\}], [\{<aCols>\}],[\{<aJust>\}], [\{<aSort>\}], ;
                     <.footers.>, <.fasted.>, <.lcell.>, <.llines.>, ;
                     [\{|nRow,nCol,nFlags|<uLClick>\}], [\{<{uAction}>\}],;
                     [\{|xSeek,nIndex|<uSeek>\}],<.eof.> )

#xcommand @ <nRow>, <nCol> CONTROL XBROWSE <oBrw> [ [ FIELDS ] <Flds,...>] ;
            [ <dsrc: ALIAS, ARRAY, RECSET, RECORDSET, OBJECT> <uDataSrc> ] ;
            [ <sizes:FIELDSIZES, SIZES, COLSIZES> <aColSizes,...> ] ;
            [ <head:HEAD,HEADER,HEADERS,TITLE> <aHeaders,...> ] ;
            [ SIZE <nWidth>, <nHeigth> ] ;
            [ <dlg:OF,DIALOG> <oDlg> ] ;
            [ <pic: PICS, PICTURE, PICTURES> <aPics,...>] ;
            [ <cols: COLS, COLUMNS> <aCols,...>] ;
            [ <idx: SORT, ORDERS> <aSort,...> ] ;
            [ JUSTIFY <aJust,...> ] ;
            [ SELECT <cField> FOR <uValue1> [ TO <uValue2> ] ] ;
            [ ON CHANGE <uChange,...> ] ;
            [ ON [ LEFT ] CLICK <uLClick,...> ] ;
            [ ON [ LEFT ] DBLCLICK <uLDblClick,...> ] ;
            [ ON RIGHT CLICK <uRClick,...> ] ;
            [ FONT <oFont> ] ;
            [ CURSOR <oCursor> ] ;
            [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
            [ MESSAGE <cMsg> ] ;
            [ <update: UPDATE> ] ;
            [ <pixel: PIXEL> ] ;
            [ WHEN <uWhen> ] ;
            [ <design: DESIGN> ] ;
            [ VALID <uValid> ] ;
            [ <autosort: AUTOSORT> ] ;
            [ <autocols: AUTOCOLS> ] ;
            [ ACTION <uAction,...> ] ;
            [ SEEK <uSeek,...> ] [<eof: EOF>];
            [ <footers: FOOTERS> ] ;
            [ <fasted: FASTEDIT> ] ;
            [ <lcell: CELL> ] [ <llines: LINES> ] ;
      => ;
          <oBrw> := qXBrowse():new( <nRow>, <nCol>, <nWidth>, <nHeigth>,;
                           [\{|| \{<Flds> \} \}], [\{<aHeaders>\}], [\{<aColSizes>\}], ;
                           <oDlg>, <(cField)>, <uValue1>, <uValue2>,;
                           [\{||<uChange>\}],;
                           [\{|nRow,nCol,nFlags,lModif,lNew,self|<uLDblClick>\}],;
                           [\{|nRow,nCol,nFlags|<uRClick>\}],;
                           <oFont>, <oCursor>, <nClrFore>, <nClrBack>, <cMsg>,;
                           <.update.>, <uDataSrc>, <.pixel.>, <{uWhen}>,;
                           <.design.>, , <{uLClick}>,;
                           [\{<{uAction}>\}], [\{| xSeek, nIndex |<uSeek>\}], <.eof.>, <.autosort.>, ;
                           <.autocols.>, [\{<aPics>\}], [\{<aCols>\}], [\{<aJust>\}], [\{<aSort>\}], ;
                           <.footers.>, <.fasted.>, <.lcell.>, <.llines.> )

//-------------------------------------------------------------------------------------------------------------------------

#xcommand DEFINE MENU BUTTON [ <oBtn> TEXT ] <cTxt> ;
            [ <bar: OF, BUTTONBAR > <oBar> ] ;
            [ <resource: NAME, RESNAME, RESOURCE> <cResName1> ;
               [,<cResName2>[,<cResName3>[,<cResName4>] ] ] ] ;
            [ <file: FILE, FILENAME, DISK> <cBmpFile1> ;
               [,<cBmpFile2>[,<cBmpFile3>[,<cBmpFile4>] ] ] ] ;
            [ <str: STRING, 8> <cBmpStr1> [,<cBmpStr2>[,<cBmpStr3>[,<cBmpStr4>] ] ] ] ;
            [ <action:ACTION,EXEC> <uAction,...> ] ;
            [ <group: GROUP, SEPARATOR> ] ;
            [ MESSAGE <cMsg> ] ;
            [ <adjust: ADJUST > ] ;
            [ WHEN <uWhen> ] ;
            [ TOOLTIP <cToolTip> ] ;
            [ <lPressed: PRESSED> ] ;
            [ ON DROP <bDrop> ] ;
            [ AT <nPos> ] ;
            [ PROMPT <cPrompt> ] ;
            [ FONT <oFont> ] ;
            [ <lNoBorder: NOBORDER, FLAT> ] ;
            [ MENU <oPopup> ] ;
            [ <layout: CENTER, TOP, LEFT, BOTTOM, RIGHT> ] ;
            [ <lTrans: TRANSPARENT>] ;
            [ JUMP <oJump> ] ;
      => ;
         [ <oBtn> := ] qBtnBmp():newBar( <cResName1>, <cResName2>,;
            <cBmpFile1>, <cBmpFile2>, <cMsg>, [{|This|<uAction>}],;
            <.group.>, <oBar>, <.adjust.>, <{uWhen}>,;
            <cToolTip>, <.lPressed.>, [\{||<bDrop>\}], [#<uAction>], <nPos>,;
            <cPrompt>, <oFont>, [<cResName3>], [<cBmpFile3>], [!<.lNoBorder.>],;
            [<oPopup>], [ Upper(<(layout)>) ],[<cResName4>], [<cBmpFile4>], <.lTrans.>, ;
            <cTxt>, <oJump>, [<cBmpStr1>], [<cBmpStr2>], [<cBmpStr3>], [<cBmpStr4>] )

#xcommand REDEFINE MENU BTNBMP [ <oBtn> TEXT ] <cTxt> ;
            [ ID <nId> ] ;
            [ <bar: OF, BUTTONBAR > <oBar> ] ;
            [ <resource: NAME, RESNAME, RESOURCE> <cResName1> ;
               [,<cResName2>[,<cResName3>[,<cResName4>] ] ] ];
            [ <file: FILE, FILENAME, DISK> <cBmpFile1> ;
               [,<cBmpFile2>[,<cBmpFile3>[,<cBmpFile4>] ] ] ] ;
            [ <str: STRING, 8> <cBmpStr1> [,<cBmpStr2>[,<cBmpStr3>[,<cBmpStr4>] ] ] ] ;
            [ <action:ACTION,EXEC,ON CLICK> <uAction,...> ] ;
            [ MESSAGE <cMsg> ] ;
            [ <adjust: ADJUST > ] ;
            [ WHEN <uWhen> ] ;
            [ <lUpdate: UPDATE> ] ;
            [ TOOLTIP <cToolTip> ] ;
            [ PROMPT <cPrompt> ] ;
            [ FONT <oFont> ] ;
            [ <lNoBorder: NOBORDER, FLAT> ] ;
            [ <layout: CENTER, TOP, LEFT, BOTTOM, RIGHT> ] ;
            [ <l2007: 2007> ] ;
            [ <lTrans: TRANSPARENT> ] ;
            [ <lNoRound: NOROUND> ];
            [ JUMP <oJump> ] ;
      => ;
         [ <oBtn> := ] qBtnBmp():reDefine( <nId>, <cResName1>, <cResName2>,;
            <cBmpFile1>, <cBmpFile2>, <cMsg>, [{|Self|<uAction>}],;
            <oBar>, <.adjust.>, <{uWhen}>, <.lUpdate.>, <cToolTip>,;
            <cPrompt>, <oFont>, [<cResName3>], [<cBmpFile3>], [!<.lNoBorder.>],;
            [ Upper(<(layout)>) ], <.l2007.>,[<cResName4>], [<cBmpFile4>], <.lTrans.>, !<.lNoRound.>, ;
            <cTxt>, <oJump>, [<cBmpStr1>], [<cBmpStr2>], [<cBmpStr3>], [<cBmpStr4>] )

#xcommand @ <nRow>, <nCol> MENU BTNBMP [ <oBtn> TEXT ] <cTxt> ;
            [ <resource: NAME, RESNAME, RESOURCE> <cResName1> ;
               [,<cResName2>[,<cResName3>[,<cResName4>] ] ] ] ;
            [ <file: FILE, FILENAME, DISK> <cBmpFile1> ;
               [,<cBmpFile2>[,<cBmpFile3>[,<cBmpFile4>] ] ] ] ;
            [ <str: STRING, 8> <cBmpStr1> [,<cBmpStr2>[,<cBmpStr3>[,<cBmpStr4>] ] ] ] ;
            [ SIZE <nWidth>, <nHeight> ] ;
            [ ACTION <uAction,...> ] ;
            [ <of:OF, WINDOW, DIALOG> <oWnd> ] ;
            [ MESSAGE <cMsg> ] ;
            [ WHEN <uWhen> ] ;
            [ <adjust: ADJUST> ] ;
            [ <lUpdate: UPDATE> ] ;
            [ PROMPT <cPrompt> ] ;
            [ FONT <oFont> ] ;
            [ TOOLTIP <cToolTip> ] ;
            [ <lNoBorder: NOBORDER, FLAT> ] ;
            [ <layout: CENTER, TOP, LEFT, BOTTOM, RIGHT> ] ;
            [ <l2007: 2007> ] ;
            [ <lTrans: TRANSPARENT> ] ;
            [ <lNoRound: NOROUND> ];
            [ JUMP <oJump> ] ;
      => ;
         [ <oBtn> := ] qBtnBmp():new( <nRow>, <nCol>, <nWidth>, <nHeight>,;
            <cResName1>, <cResName2>, <cBmpFile1>, <cBmpFile2>,;
            [{|Self|<uAction>}], <oWnd>, <cMsg>, <{uWhen}>, <.adjust.>,;
            <.lUpdate.>, <cPrompt>, <oFont>, [<cResName3>], [<cBmpFile3>],;
            !<.lNoBorder.>, [ Upper(<(layout)>) ], <.l2007.>,[<cResName4>], [<cBmpFile4>], ;
            <.lTrans.>,<cToolTip>,!<.lNoRound.>, ;
            <cTxt>, <oJump>, [<cBmpStr1>], [<cBmpStr2>], [<cBmpStr3>], [<cBmpStr4>] )

#xcommand MENUITEM [ <oMenuItem>  ] BUTTON [ <oBtn> PROMPT ] <cPrompt> ;
            [ <bar: OF, BUTTONBAR > <oBar> ] ;
            [ <resource: NAME, RESNAME, RESOURCE> <cResName1> ;
               [,<cResName2>[,<cResName3>[,<cResName4>] ] ] ] ;
            [ <file: FILE, FILENAME, DISK> <cBmpFile1> ;
               [,<cBmpFile2>[,<cBmpFile3>[,<cBmpFile4>] ] ] ] ;
            [ <str: STRING, 8> <cBmpStr1> [,<cBmpStr2>[,<cBmpStr3>[,<cBmpStr4>] ] ] ] ;
            [ <action:ACTION,EXEC> <uAction,...> ] ;
            [ <group: GROUP, SEPARATOR> [<oSeparator>] ] ;
            [ MESSAGE <cMsg> ] ;
            [ <adjust: ADJUST > ] ;
            [ WHEN <uWhen> ] ;
            [ TOOLTIP <cToolTip> ] ;
            [ <lPressed: PRESSED> ] ;
            [ ON DROP <bDrop> ] ;
            [ AT <nPos> ] ;
            [ TEXT <cTxt> ] ;
            [ FONT <oFont> ] ;
            [ <lNoBorder: NOBORDER, FLAT> ] ;
            [ MENU <oPopup> ] ;
            [ <layout: CENTER, TOP, LEFT, BOTTOM, RIGHT> ] ;
            [ <lTrans: TRANSPARENT>] ;
            [ JUMP <oJump> ] ;
            [ <checked: CHECK, CHECKED, MARK> ] ;
            [ <enable: ENABLED, DISABLED> ] ;
            [ BLOCK <bAction> ] ;
            [ <of: OF, MENU, SYSMENU> <oMenu> ] ;
            [ <help: HELP> ] ;
            [ <helpId: HELP ID, HELPID> <nHelpId> ] ;
            [ <break: BREAK> ] ;
            [ ACCELERATOR <nState>, <nVirtKey> ] ;
      => ;
         [ IF <.group.> ; SEPARATOR <oSeparator> ; ENDIF ; ] ;
         MENUITEM M->__o_qs_var__ [ := <oMenuItem> ] PROMPT <cPrompt> [ MESSAGE <cMsg> ] [ <checked> ] ;
             [ <enable> ] [ FILE <cBmpFile1> ] [ RESOURCE <cResName1> ] ;
             [ ACTION <uAction> ] [ BLOCK <bAction> ] [ SYSMENU <oMenu> ] ;
             [ ACCELERATOR <nState>, <nVirtKey> ] [ <help> ] [ <nHelpId> ] ;
             [ WHEN <uWhen> ] [ <break> ] ;;
         [ M->__o_qs_var__:hBitmap := createMemBitmap( getAllWin()\[ aScan( getAllWin(), \{ | x | x <> nil \} ) \]:getDC(), <cBmpStr1> ) ; getAllWin()\[ aScan( GetAllWin(), \{ | x | x <> nil \} ) \]:releaseDC() ; ] ;
         [ <oBtn> := ] qBtnBmp():newBar( <cResName1>, <cResName2>,;
            <cBmpFile1>, <cBmpFile2>, <cMsg>, ;
            if( <.bAction.>, [ <bAction> ], [ {|this| <uAction> } ] ), ;
            <.group.>, <oBar>, <.adjust.>, <{uWhen}>, <cToolTip>, ;
            <.lPressed.>, [ \{ || <bDrop> \} ], ;
            if( <.bAction.>, [ #<bAction> ], [ #<uAction> ] ), <nPos>,;
            /*
             * <cPrompt>*/, <oFont>, [<cResName3>], [<cBmpFile3>], [!<.lNoBorder.>],;
            [<oPopup>], [ Upper(<(layout)>) ],[<cResName4>], [<cBmpFile4>], <.lTrans.>, ;
            if( <.cTxt.>, <cTxt>, <cPrompt> ), <oJump>, [<cBmpStr1>], [<cBmpStr2>], [<cBmpStr3>], [<cBmpStr4>] )

//----------------------------------------------------------------------------------------------------------------------

#xcommand DBFAbre <xNombre,...> [VAR <var>] [ALIAS <xAlias,...>] [<shared: SHARED>] ;
            [<exclusive: EXCLUSIVE>][DIR <cDirect>] [INDEX <xIndice,...>] ;
            [<nogenera: NOGENERA>] [<nueva: NEW>] [<nonueva: NONEW>] ;
            [<lSoloLeer: READONLY>] [FUNCION <cFuncion>] [<nocerrar: NOCERRAR>] ;
            [<noMensajes: NOMENSAJE,NOMENSAJES>] [VIA <cRDD>] ;
            [<lNoMsgAbr: NOMSGABRIENDO>] ;
      => ;
         [<var> :=] abreDBF(\{<(xNombre)>\} , [\{<(xAlias)>\}],;
               if(<.shared.> .or. <.exclusive.>, <.shared.>, NIL), <cDirect>, ;
               \{<xIndice>\}, !<.nogenera.>, !<.nonueva.>, <.lSoloLeer.>, ;
               <cFuncion>, !<.nocerrar.>, <.noMensajes.>, <cRDD>, <.lNoMsgAbr.>)

#xcommand IF [<not:!,.NOT.>] DBFAbre  <xNombre,...> [VAR <var>] [ALIAS <xAlias,...>] ;
            [<shared: SHARED>] [<exclusive: EXCLUSIVE>][DIR <cDirect>] ;
            [INDEX <xIndice,...>] [<nogenera: NOGENERA>] [<nueva: NEW>] ;
            [<nonueva: NONEW>] [<lSoloLeer: READONLY>] [FUNCION <cFuncion>] ;
            [<nocerrar: NOCERRAR>] [<noMensajes: NOMENSAJE,NOMENSAJES>] [VIA <cRDD>] ;
            [<lNoMsgAbr: NOMSGABRIENDO>] ;
      => ;
         if [ <not>] ( [ <var> := ] abreDBF(\{<(xNombre)>\} , [\{<(xAlias)>\}],;
               if(<.shared.> .or. <.exclusive.>, <.shared.>, NIL), <cDirect>, ;
               \{<xIndice>\}, !<.nogenera.>, !<.nonueva.>, <.lSoloLeer.>, ;
               <cFuncion>, !<.nocerrar.>, <.noMensajes.>, <cRDD>, <.lNoMsgAbr.>) )

//----------------------------------------------------------------------------------------------------------------------

#XCOMMAND CLOSE <areas:AREA,AREAS> <xAreas,...> => cierraArea(\{<(xAreas)>\})

//----------------------------------------------------------------------------------------------------------------------

#XCOMMAND CREATE INDEX <aFormIndice,...> TO <aIndices,...> [VAR <var>];
            [<name:FILE|DBF> <(cNombre)>] [DIR <(cDirect)>] ;
            [<tags:TAG|TAGS> <aTags,...>] [FOR <aFor,...>] ;
            [DESCEND <aDescend,...>] [UNIQUE <aUnico,...>] ;
            [<noMensajes: NOMENSAJE,NOMENSAJES>] ;
      => ;
         [<var> :=] creaIndex(<(cNombre)>,<(cDirect)>,\{<(aIndices)>\},;
               \{<"aFormIndice">\},\{<(aTags)>\},\{<(aFor)>\},\{<aDescend>\},;
               \{<aUnico>\}, <.noMensajes.>)

#XCOMMAND IF [<not:!,.NOT.>] CREATE INDEX <aFormIndice,...> TO <aIndices,...> ;
            [VAR <var>] [<name:FILE|DBF> <(cNombre)>] [DIR <(cDirect)>] ;
            [<tags:TAG|TAGS> <aTags,...>] [FOR <aFor,...>] ;
            [DESCEND <aDescend,...>] [UNIQUE <aUnico,...>] ;
            [<noMensajes: NOMENSAJE,NOMENSAJES>] ;
      => ;
         if [ <not>] ( [<var> :=] creaIndex(<(cNombre)>,<(cDirect)>,\{<(aIndices)>\},;
            \{<"aFormIndice">\},\{<(aTags)>\},\{<(aFor)>\},\{<aDescend>\},;
            \{<aUnico>\}), <.noMensajes.> )

//----------------------------------------------------------------------------------------------------------------------

#XCOMMAND IF [<not:!,.NOT.>] PSWD [<xModulo>] [<tit:TITLE|TITULO> <cTitulo>] ;
            [<lError:MSGERROR>] [<lNoError:NOMSGERROR>] [INTENTOS <nOpor>] ;
            [DIR <cDir>] [HELPID <nAyuda>] [<arch:FILE|ARCHIVO|ARCH> <cArchivo>] ;
      => ;
         if [ <not>] PASSWORD(<xModulo>, <cTitulo>, if(<.lError.>,.t.,!<lNoError>), ;
            <nOpor>, <cDir>, <nAyuda>, <cArchivo>)

//----------------------------------------------------------------------------------------------------------------------
// Clase tArray

#command DEFINE STRUCT [<oTArray>] [INIT <aInit>] => ;
         [<oTArray>:= ]__StructNew(<aInit>)
#command STRUCT FIELD <(cName)> [INIT <uInit>] [DEFAULT <uDefault>] => ;
         __StructField(<(cName)>,<uInit>,<uDefault> )
#command END STRUCT => __StructEnd()

//----------------------------------------------------------------------------------------------------------------------
// Clase comBrow

#xcommand REDEFINE COMBROWSE [ <oCbx> VAR ] <cVar> ;
            [ ALIAS <cAlias> ] ;
            [ ID <nId> ] ;
            [ <dlg:OF,WINDOW,DIALOG> <oWnd> ] ;
            [ <help:HELPID, HELP ID> <nHelpId> ] ;
            [ ON CHANGE <uChange> ] ;
            [ VALID   <uValid> ] ;
            [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
            [ <update: UPDATE> ] ;
            [ MESSAGE <cMsg> ] ;
            [ WHEN <uWhen> ] ;
            [ BITMAPS <acBitmaps> ] ;
            [ ON DRAWITEM <uBmpSelect> ] ;
            [ STYLE <nStyle> ] ;
            [ PICTURE <cPicture> ];
            [ ON EDIT CHANGE <uEChange> ] ;
            [ FIELDS <aFields,...>] ;
            [ FIELDGET <cFieldGet> ] ;
      => ;
         [ <oCbx> := ] qComBrowse():ReDefine( <nId>, bSETGET(<cVar>),;
            <cAlias>, <oWnd>, <nHelpId>, <{uValid}>, [{|Self|<uChange>}],;
            <nClrText>, <nClrBack>, <cMsg>, <.update.>, <{uWhen}>,;
            <acBitmaps>, [{|nItem|<uBmpSelect>}], <nStyle>, <cPicture>,;
            [<{uEChange}>], [{||{<aFields>}}], <{cFieldGet}> )

#xcommand @ <nRow>, <nCol> COMBROWSE [ <oCbx> VAR ] <cVar> ;
            [ ALIAS <cAlias> ] ;
            [ SIZE <nWidth>, <nHeight> ] ;
            [ <dlg:OF,WINDOW,DIALOG> <oWnd> ] ;
            [ <help:HELPID, HELP ID> <nHelpId> ] ;
            [ ON CHANGE <uChange> ] ;
            [ VALID <uValid> ] ;
            [ <color: COLOR,COLORS> <nClrText> [,<nClrBack>] ] ;
            [ <pixel: PIXEL> ] ;
            [ FONT <oFont> ] ;
            [ <update: UPDATE> ] ;
            [ MESSAGE <cMsg> ] ;
            [ WHEN <uWhen> ] ;
            [ <design: DESIGN> ] ;
            [ BITMAPS <acBitmaps> ] ;
            [ ON DRAWITEM <uBmpSelect> ] ;
            [ STYLE <nStyle> ] ;
            [ PICTURE <cPicture> ];
            [ ON EDIT CHANGE <uEChange> ] ;
            [ FIELDS <aFields,...>] ;
            [ FIELDGET <cFieldGet> ] ;
      => ;
         [ <oCbx> := ] qComBrowse():New( <nRow>, <nCol>, bSETGET(<cVar>),;
            <cAlias>, <nWidth>, <nHeight>, <oWnd>, <nHelpId>,;
            [{|Self|<uChange>}], <{uValid}>, <nClrText>, <nClrBack>,;
            <.pixel.>, <oFont>, <cMsg>, <.update.>, <{uWhen}>,;
            <.design.>, <acBitmaps>, [{|nItem|<uBmpSelect>}], <nStyle>,;
            <cPicture>, [<{uEChange}>], [{||{<aFields>}}], <{cFieldGet}> )

//----------------------------------------------------------------------------------------------------------------------
// Control de apertura de archivos por grupos
#xcommand DBFS [ <objeto> ] => private __o_qs_entorno__; [ <objeto> := ] M->__o_qs_entorno__ := qEntorno():new()

// Abrrir un archvo
#xcommand DBF <(cArchivo)> [ <index: INDEX> <ncIndice> ] [ ALIAS <alias> ] ;
            [ <object: OBJECT, OBJETO> <objeto> ] [ <privado: PRIVADO, PRIVATE> ] ; // solo para este entorno o compartido
            [<ex: EXCLUSIVE>] [<sh: SHARED>] [ VIA <rdd> ] [ <ro: READONLY> ] ;
            [ <lock: LOCK, LOCKED> <xLock> ] ;
      => ;
         M->__o_qs_entorno__:add( <(cArchivo)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ] )

#xcommand DBF <obj> FILE <(cArchivo)> [ <index: INDEX> <ncIndice> ] [ ALIAS <alias> ] ;
            [ <object: OBJECT, OBJETO> <objeto> ] [ <privado: PRIVADO, PRIVATE> ] ; // solo para este entorno o compartido
            [<ex: EXCLUSIVE>] [<sh: SHARED>] [ VIA <rdd> ] [ <ro: READONLY> ] ;
            [ <lock: LOCK, LOCKED> <xLock> ] ;
      => ;
         <obj>:add( <(cArchivo)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ] )

// Crear indice no inteligente <"key">, <(tag)>, <(bag)>, <"for">
#XCOMMAND DBF <(cArch)> INDEX [ON]<key> TAG <tag> [TO <(bag)>] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <for>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         M->__o_qs_entorno__:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <"key">, <(tag)>, <(bag)>, <"for">, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

#XCOMMAND DBF <(cArch)> INDEX [ON]<key> TO <(bag)> [ TAG <tag> ] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <for>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         M->__o_qs_entorno__:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <"key">, <(tag)>, <(bag)>, <"for">, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

#XCOMMAND DBF <obj> FILE <(cArch)> INDEX [ON]<key> TAG <tag> [TO <(bag)>] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <for>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         <obj>:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <"key">, <(tag)>, <(bag)>, <"for">, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

#XCOMMAND DBF <obj> FILE <(cArch)> INDEX [ON]<key> TO <(bag)> [ TAG <tag> ] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <for>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         <obj>:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <"key">, <(tag)>, <(bag)>, <"for">, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

// Crear indice ineligente <(key)>, <(tag)>, <(bag)>, <(for)>
#XCOMMAND DBF <(cArch)> KEY <(key)> TAG <tag> [TO <(bag)>] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <(for)>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         M->__o_qs_entorno__:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <(key)>, <(tag)>, <(bag)>, <(for)>, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

#XCOMMAND DBF <(cArch)> KEY <(key)> TO <(bag)> [ TAG <tag> ] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <(for)>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         M->__o_qs_entorno__:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <(key)>, <(tag)>, <(bag)>, <(for)>, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

#XCOMMAND DBF <obj> FILE <(cArch)> KEY <(key)> TAG <tag> [TO <(bag)>] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <(for)>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         <obj>:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <(key)>, <(tag)>, <(bag)>, <(for)>, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

#XCOMMAND DBF <obj> FILE <(cArch)> KEY <(key)> TO <(bag)> [ TAG <tag> ] ;
            [ ALIAS <alias> ] [ <object: OBJECT, OBJETO> <objeto> ] ;
            [ VIA <rdd> ] [ <ro: READONLY> ] [ <ex: EXCLUSIVE> ] [ <sh: SHARED> ] ;
            [ <privado: PRIVADO, PRIVATE> ] [ <lock: LOCK, LOCKED> <xLock> ] ;
            [ FOR <(for)>] [ <unique: UNIQUE>] ;
            [ <ascend: ASCENDING>] [<descend: DESCENDING>] ;
            [<cust: CUSTOM>] [ <noopt: NOOPTIMIZE>] ;
      => ;
         <obj>:add( <(cArch)>, <.privado.>, [ @<alias> ], [ @<objeto> ], ;
            if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ), <.ro.>, <rdd>, [ <xLock> ], ;
            <(key)>, <(tag)>, <(bag)>, <(for)>, [ <.unique.> ], [ <.descend.> ], ;
            [ <.cust.> ], [ <.noopt.> ] )

#XCOMMAND DBF INDEX <func:FUNCTION, FUNC, BLOCK> <funcion> [ <obj> ]=> hb_execFromArray( <funcion>, { if( <.obj.>, <obj>, M->__o_qs_entorno__ ) } )

#XCOMMAND DBFS REINDEX [ <oEntorno> ] [ TITLE <titulo> ] [ <resource: NAME, RESNAME, RESOURCE> <(cSi)> [,<(cNo)> ] ] ;
         [ <usr:USUARIO, USER, USR, PERMISO> <nPermiso> [ ,<oUsr> ] ] ;
      => ;
         iif( <.oEntorno.>, <oEntorno>, M->__o_qs_entorno__ ):reindex( , <titulo>, <(cSi)>, <(cNo)>, <nPermiso>, <oUsr> )

#XCOMMAND DBFS UPDATE [ <oEntorno> <func:FUNCTION, FUNC, BLOCK> ] <funcion> [ TITLE <titulo> ] ;
            [ <resource: RESNAME, RESOURCE> <(cSi)> [,<(cNo)> ] ] ;
      => ;
         iif( <.oEntorno.>, <oEntorno>, M->__o_qs_entorno__ ):reindex( <funcion>, <titulo>, <(cSi)>, <(cNo)> )

#xcommand END DBFS [ <oEntorno> ] => iif( <.oEntorno.>, <oEntorno>, M->__o_qs_entorno__ ):open()

#xcommand IF [<not:!,.NOT.>] END DBFS [ <oEntorno> ]=> if (<not>if( <.oEntorno.>, <oEntorno>, M->__o_qs_entorno__ ):open())

#XCOMMAND CLOSE DBFS [ <oEntorno> ] => iif( <.oEntorno.>, <oEntorno>, M->__o_qs_entorno__ ):close()

//-------------------------------------------------------------------------------------------------------------------------

#XCOMMAND AGETS <aVal> [ <prm:PROMPT, PROMPTS> <aTextos,...> ] [ TITLE <cTitulo> ] [ <pic:PICT, PICTURE, PICTURES> <aPicture> ] ;
            [ <sis:SIZE, SIZES> <aTamGet> ] [ <whe:WHEN, WHENS> <abWhen> ] [ <val:VALID, VALIDS> <abValid> ] ;
            [ <msg:MSG, MSGS, MESSAGE, MESSAGES> <aMensaje> ] [ ALIGN <aAlineado> ] [ <fnt:FONT, FONTS> <oLetra> ] ;
      => ;
         aGet( <aVal>, { <aTextos> }, <cTitulo>, <aPicture>, <aTamGet>, <abWhen>, <abValid>, <aMensaje>, <aAlineado>, <oLetra> )

#XCOMMAND IF AGETS <aVal> [ <prm:PROMPT, PROMPTS> <aTextos,...> ] [ TITLE <cTitulo> ] [ <pic:PICT, PICTURE, PICTURES> <aPicture> ] ;
            [ <sis:SIZE, SIZES> <aTamGet> ] [ <whe:WHEN, WHENS> <abWhen> ] [ <val:VALID, VALIDS> <abValid> ] ;
            [ <msg:MSG, MSGS, MESSAGE, MESSAGES> <aMensaje> ] [ ALIGN <aAlineado> ] [ <fnt:FONT, FONTS> <oLetra> ] ;
      => ;
         if aGet( <aVal>, { <aTextos> }, <cTitulo>, <aPicture>, <aTamGet>, <abWhen>, <abValid>, <aMensaje>, <aAlineado>, <oLetra> )

//-------------------------------------------------------------------------------------------------------------------------

#XCOMMAND REDEFINE GET <oGet> [ <params1> ] KEY <key> [ <params2> ] ;
      => ;
         REDEFINE GET <oGet> [ <params1> ] [ <params2> ] ;;
            <oGet>:bKeyDown := \{ | nKey, nFlags, Self | if( chr( nKey ) $ <key>, ( <oGet>:oBtn:click(), ;
            <oGet>:oWnd:goNextCtrl( <oGet>:hWnd ), 0 ), 1 ) \}

//-------------------------------------------------------------

#xcommand REDEFINE GET <oGet> BITMAP <oBmp> VAR <xVar> ;
             [ ID <nIdGet>, <nIdBmp> ] ;
             [ <dlg: OF, WINDOW, DIALOG> <oDlg> ] ;
             [ <help:HELPID, HELP ID> <nHelpId> ] ;
             [ VALID   <ValidFunc> ]       ;
             [ PICTURE <cPict> ] ;
             [ <color:COLOR,COLORS> <nClrFore> [,<nClrBack>] ] ;
             [ KEY <key> ] ;
             [ FONT <oFont> ] ;
             [ <update: UPDATE> ] ;
             [ WHEN <uWhen> ] ;
             [ <lClick: ON CLICK, ON LEFT CLICK> <uLClick> ] ;
             [ <readonly: READONLY, NO MODIFY> ] ;
             [ <spin: SPINNER> [ON UP <SpnUp>] [ON DOWN <SpnDn>] [MIN <Min>] [MAX <Max>] ] ;
             [ <resource: NAME, RESNAME, RESOURCE> <cResName> ] ;
             [ <file: FILE, FILENAME, DISK> <cBmpFile> ] ;
             [ <transparent: TRANSPARENT> ] ;
       => ;
          <oGet> := tGet():ReDefine( <nIdGet>, bSETGET(<xVar>), <oDlg>,;
             <nHelpId>, <cPict>, <{ValidFunc}>, <nClrFore>, <nClrBack>,;
             <oFont>,,, <.update.>, <{uWhen}>,, <.readonly.>,;
             <.spin.>, <{SpnUp}>, <{SpnDn}>, <{Min}>, <{Max}>) ;;
          <oGet>:bKeyDown := {| nKey, nFlags, Self | if( if( <.key.>, [ nKey == <key> ], chr( nKey ) $ "+k" ), ( [ <uLClick>, ]<oGet>:refresh(), <oGet>:setFocus(), <oGet>:oWnd:goNextCtrl( <oGet>:hWnd ), 0 ), 1 ) \} ;;
          <oBmp> := tBitmap():reDefine( <nIdBmp>, <cResName>, <cBmpFile>,<oDlg>, ;
             \{ |nRow,nCol,nKey| [ <uLClick>, ]<oGet>:refresh(), <oGet>:setFocus(), <oGet>:oWnd:goNextCtrl( <oGet>:hWnd ) \},,,,,, ;
             <.update.>, <{uWhen}>,, <.transparent.> ) ;;
         <oBmp>:bMMoved := { || cursorHand() }

#ifndef __XHARBOUR__
//#INCLUDE "hbcompat.CH"
#INCLUDE "xHb.CH"
#XCOMMAND global extern <x,...> => memvar <x>
#endif

#endif   // _qsoft_ch